/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FastDatePrinter$Rule;

class FastDatePrinter$Iso8601_Rule
implements FastDatePrinter$Rule {
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS = new FastDatePrinter$Iso8601_Rule(3);
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS_MINUTES = new FastDatePrinter$Iso8601_Rule(5);
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new FastDatePrinter$Iso8601_Rule(6);
    final int length;

    static FastDatePrinter$Iso8601_Rule getRule(int n) {
        switch (n) {
            case 1: {
                return ISO8601_HOURS;
            }
            case 2: {
                return ISO8601_HOURS_MINUTES;
            }
            case 3: {
                return ISO8601_HOURS_COLON_MINUTES;
            }
        }
        throw new IllegalArgumentException("invalid number of X");
    }

    FastDatePrinter$Iso8601_Rule(int n) {
        this.length = n;
    }

    @Override
    public int estimateLength() {
        return this.length;
    }

    @Override
    public void appendTo(Appendable appendable, Calendar calendar) {
        int n = calendar.get(15) + calendar.get(16);
        if (n == 0) {
            appendable.append("Z");
            return;
        }
        if (n < 0) {
            appendable.append('-');
            n = -n;
        } else {
            appendable.append('+');
        }
        int n2 = n / 3600000;
        FastDatePrinter.access$000(appendable, n2);
        if (this.length < 5) {
            return;
        }
        if (this.length == 6) {
            appendable.append(':');
        }
        int n3 = n / 60000 - 60 * n2;
        FastDatePrinter.access$000(appendable, n3);
    }
}

