/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.FileHandle;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lokio/FileHandle$FileHandleSource;", "Lokio/Source;", "fileHandle", "Lokio/FileHandle;", "position", "", "(Lokio/FileHandle;J)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "getFileHandle", "()Lokio/FileHandle;", "getPosition", "()J", "setPosition", "(J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "okio"})
@SourceDebugExtension(value={"SMAP\nFileHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -JvmPlatform.kt\nokio/_JvmPlatformKt\n*L\n1#1,444:1\n1#2:445\n33#3:446\n*S KotlinDebug\n*F\n+ 1 FileHandle.kt\nokio/FileHandle$FileHandleSource\n*L\n436#1:446\n*E\n"})
final class FileHandle$FileHandleSource
implements Source {
    @NotNull
    private final FileHandle fileHandle;
    private long position;
    private boolean closed;

    public FileHandle$FileHandleSource(@NotNull FileHandle fileHandle, long l) {
        Intrinsics.checkNotNullParameter(fileHandle, "fileHandle");
        this.fileHandle = fileHandle;
        this.position = l;
    }

    @NotNull
    public final FileHandle getFileHandle() {
        return this.fileHandle;
    }

    public final long getPosition() {
        return this.position;
    }

    public final void setPosition(long l) {
        this.position = l;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public long read(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        long l2 = FileHandle.access$readNoCloseCheck(this.fileHandle, this.position, buffer, l);
        if (l2 != -1L) {
            this.position += l2;
        }
        return l2;
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ReentrantLock reentrantLock = this.fileHandle.getLock();
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            FileHandle fileHandle = this.fileHandle;
            int n = FileHandle.access$getOpenStreamCount$p(fileHandle);
            FileHandle.access$setOpenStreamCount$p(fileHandle, n + -1);
            if (FileHandle.access$getOpenStreamCount$p(this.fileHandle) != 0 || !FileHandle.access$getClosed$p(this.fileHandle)) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.fileHandle.protectedClose();
    }
}

