/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidSocketAdapter$Companion;
import okhttp3.internal.platform.android.DeferredSocketAdapter$Factory;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter$DefaultImpls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/platform/android/AndroidSocketAdapter;", "Lokhttp3/internal/platform/android/SocketAdapter;", "sslSocketClass", "Ljava/lang/Class;", "Ljavax/net/ssl/SSLSocket;", "(Ljava/lang/Class;)V", "getAlpnSelectedProtocol", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "setAlpnProtocols", "setHostname", "setUseSessionTickets", "configureTlsExtensions", "", "sslSocket", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "getSelectedProtocol", "isSupported", "", "matchesSocket", "Companion", "okhttp"})
public class AndroidSocketAdapter
implements SocketAdapter {
    @NotNull
    public static final AndroidSocketAdapter$Companion Companion = new AndroidSocketAdapter$Companion(null);
    @NotNull
    private final Class<? super SSLSocket> sslSocketClass;
    @NotNull
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    @NotNull
    private static final DeferredSocketAdapter$Factory playProviderFactory = Companion.factory("com.google.android.gms.org.conscrypt");

    public AndroidSocketAdapter(@NotNull Class<? super SSLSocket> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "sslSocketClass");
        this.sslSocketClass = clazz;
        Class[] classArray = new Class[]{Boolean.TYPE};
        Method method = this.sslSocketClass.getDeclaredMethod("setUseSessionTickets", classArray);
        Intrinsics.checkNotNullExpressionValue(method, "sslSocketClass.getDeclar\u2026:class.javaPrimitiveType)");
        this.setUseSessionTickets = method;
        Class[] classArray2 = new Class[]{String.class};
        this.setHostname = this.sslSocketClass.getMethod("setHostname", classArray2);
        this.getAlpnSelectedProtocol = this.sslSocketClass.getMethod("getAlpnSelectedProtocol", new Class[0]);
        classArray2 = new Class[]{byte[].class};
        this.setAlpnProtocols = this.sslSocketClass.getMethod("setAlpnProtocols", classArray2);
    }

    @Override
    public boolean isSupported() {
        return AndroidPlatform.Companion.isSupported();
    }

    @Override
    public boolean matchesSocket(@NotNull SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        return this.sslSocketClass.isInstance(sSLSocket);
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sSLSocket, @Nullable String string, @NotNull List<? extends Protocol> list) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (this.matchesSocket(sSLSocket)) {
            try {
                Object[] objectArray = new Object[]{true};
                this.setUseSessionTickets.invoke((Object)sSLSocket, objectArray);
                if (string != null) {
                    objectArray = new Object[]{string};
                    this.setHostname.invoke((Object)sSLSocket, objectArray);
                }
                objectArray = new Object[]{Platform.Companion.concatLengthPrefixed(list)};
                this.setAlpnProtocols.invoke((Object)sSLSocket, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sSLSocket) {
        Object object;
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        if (!this.matchesSocket(sSLSocket)) {
            return null;
        }
        try {
            object = (byte[])this.getAlpnSelectedProtocol.invoke((Object)sSLSocket, new Object[0]);
            object = object != null ? new String((byte[])object, Charsets.UTF_8) : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (!(throwable instanceof NullPointerException) || !Intrinsics.areEqual(((NullPointerException)throwable).getMessage(), "ssl == null")) {
                throw new AssertionError((Object)invocationTargetException);
            }
            object = null;
        }
        return object;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sSLSocketFactory) {
        return SocketAdapter$DefaultImpls.trustManager(this, sSLSocketFactory);
    }

    @Override
    public boolean matchesSocketFactory(@NotNull SSLSocketFactory sSLSocketFactory) {
        return SocketAdapter$DefaultImpls.matchesSocketFactory(this, sSLSocketFactory);
    }

    public static final /* synthetic */ DeferredSocketAdapter$Factory access$getPlayProviderFactory$cp() {
        return playProviderFactory;
    }
}

