/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Connection$Listener;
import okhttp3.internal.http2.PushObserver;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006:"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "okhttp"})
public final class Http2Connection$Builder {
    private boolean client;
    @NotNull
    private final TaskRunner taskRunner;
    public Socket socket;
    public String connectionName;
    public BufferedSource source;
    public BufferedSink sink;
    @NotNull
    private Http2Connection$Listener listener;
    @NotNull
    private PushObserver pushObserver;
    private int pingIntervalMillis;

    public Http2Connection$Builder(boolean bl, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        this.client = bl;
        this.taskRunner = taskRunner;
        this.listener = Http2Connection$Listener.REFUSE_INCOMING_STREAMS;
        this.pushObserver = PushObserver.CANCEL;
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final void setClient$okhttp(boolean bl) {
        this.client = bl;
    }

    @NotNull
    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    @NotNull
    public final Socket getSocket$okhttp() {
        Socket socket = this.socket;
        if (socket != null) {
            return socket;
        }
        Intrinsics.throwUninitializedPropertyAccessException("socket");
        return null;
    }

    public final void setSocket$okhttp(@NotNull Socket socket) {
        Intrinsics.checkNotNullParameter(socket, "<set-?>");
        this.socket = socket;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        String string = this.connectionName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("connectionName");
        return null;
    }

    public final void setConnectionName$okhttp(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.connectionName = string;
    }

    @NotNull
    public final BufferedSource getSource$okhttp() {
        BufferedSource bufferedSource = this.source;
        if (bufferedSource != null) {
            return bufferedSource;
        }
        Intrinsics.throwUninitializedPropertyAccessException("source");
        return null;
    }

    public final void setSource$okhttp(@NotNull BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<set-?>");
        this.source = bufferedSource;
    }

    @NotNull
    public final BufferedSink getSink$okhttp() {
        BufferedSink bufferedSink = this.sink;
        if (bufferedSink != null) {
            return bufferedSink;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sink");
        return null;
    }

    public final void setSink$okhttp(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(bufferedSink, "<set-?>");
        this.sink = bufferedSink;
    }

    @NotNull
    public final Http2Connection$Listener getListener$okhttp() {
        return this.listener;
    }

    public final void setListener$okhttp(@NotNull Http2Connection$Listener http2Connection$Listener) {
        Intrinsics.checkNotNullParameter(http2Connection$Listener, "<set-?>");
        this.listener = http2Connection$Listener;
    }

    @NotNull
    public final PushObserver getPushObserver$okhttp() {
        return this.pushObserver;
    }

    public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
        Intrinsics.checkNotNullParameter(pushObserver, "<set-?>");
        this.pushObserver = pushObserver;
    }

    public final int getPingIntervalMillis$okhttp() {
        return this.pingIntervalMillis;
    }

    public final void setPingIntervalMillis$okhttp(int n) {
        this.pingIntervalMillis = n;
    }

    @JvmOverloads
    @NotNull
    public final Http2Connection$Builder socket(@NotNull Socket socket, @NotNull String string, @NotNull BufferedSource bufferedSource, @NotNull BufferedSink bufferedSink) {
        Http2Connection$Builder http2Connection$Builder;
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(string, "peerName");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        Http2Connection$Builder http2Connection$Builder2 = http2Connection$Builder = this;
        boolean bl = false;
        http2Connection$Builder2.setSocket$okhttp(socket);
        http2Connection$Builder2.setConnectionName$okhttp(http2Connection$Builder2.client ? Util.okHttpName + ' ' + string : "MockWebServer " + string);
        http2Connection$Builder2.setSource$okhttp(bufferedSource);
        http2Connection$Builder2.setSink$okhttp(bufferedSink);
        return http2Connection$Builder;
    }

    public static /* synthetic */ Http2Connection$Builder socket$default(Http2Connection$Builder http2Connection$Builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) {
        if ((n & 2) != 0) {
            string = Util.peerName(socket);
        }
        if ((n & 4) != 0) {
            bufferedSource = Okio.buffer(Okio.source(socket));
        }
        if ((n & 8) != 0) {
            bufferedSink = Okio.buffer(Okio.sink(socket));
        }
        return http2Connection$Builder.socket(socket, string, bufferedSource, bufferedSink);
    }

    @NotNull
    public final Http2Connection$Builder listener(@NotNull Http2Connection$Listener http2Connection$Listener) {
        Http2Connection$Builder http2Connection$Builder;
        Intrinsics.checkNotNullParameter(http2Connection$Listener, "listener");
        Http2Connection$Builder http2Connection$Builder2 = http2Connection$Builder = this;
        boolean bl = false;
        http2Connection$Builder2.listener = http2Connection$Listener;
        return http2Connection$Builder;
    }

    @NotNull
    public final Http2Connection$Builder pushObserver(@NotNull PushObserver pushObserver) {
        Http2Connection$Builder http2Connection$Builder;
        Intrinsics.checkNotNullParameter(pushObserver, "pushObserver");
        Http2Connection$Builder http2Connection$Builder2 = http2Connection$Builder = this;
        boolean bl = false;
        http2Connection$Builder2.pushObserver = pushObserver;
        return http2Connection$Builder;
    }

    @NotNull
    public final Http2Connection$Builder pingIntervalMillis(int n) {
        Http2Connection$Builder http2Connection$Builder;
        Http2Connection$Builder http2Connection$Builder2 = http2Connection$Builder = this;
        boolean bl = false;
        http2Connection$Builder2.pingIntervalMillis = n;
        return http2Connection$Builder;
    }

    @NotNull
    public final Http2Connection build() {
        return new Http2Connection(this);
    }

    @JvmOverloads
    @NotNull
    public final Http2Connection$Builder socket(@NotNull Socket socket, @NotNull String string, @NotNull BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(string, "peerName");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        return Http2Connection$Builder.socket$default(this, socket, string, bufferedSource, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Http2Connection$Builder socket(@NotNull Socket socket, @NotNull String string) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(string, "peerName");
        return Http2Connection$Builder.socket$default(this, socket, string, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final Http2Connection$Builder socket(@NotNull Socket socket) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        return Http2Connection$Builder.socket$default(this, socket, null, null, null, 14, null);
    }
}

