/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.http2.Header$Companion;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00062\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\nH\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/http2/Header;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "Lokio/ByteString;", "(Lokio/ByteString;Ljava/lang/String;)V", "(Lokio/ByteString;Lokio/ByteString;)V", "hpackSize", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "okhttp"})
public final class Header {
    @NotNull
    public static final Header$Companion Companion = new Header$Companion(null);
    @JvmField
    @NotNull
    public final ByteString name;
    @JvmField
    @NotNull
    public final ByteString value;
    @JvmField
    public final int hpackSize;
    @JvmField
    @NotNull
    public static final ByteString PSEUDO_PREFIX = ByteString.Companion.encodeUtf8(":");
    @NotNull
    public static final String RESPONSE_STATUS_UTF8 = ":status";
    @NotNull
    public static final String TARGET_METHOD_UTF8 = ":method";
    @NotNull
    public static final String TARGET_PATH_UTF8 = ":path";
    @NotNull
    public static final String TARGET_SCHEME_UTF8 = ":scheme";
    @NotNull
    public static final String TARGET_AUTHORITY_UTF8 = ":authority";
    @JvmField
    @NotNull
    public static final ByteString RESPONSE_STATUS = ByteString.Companion.encodeUtf8(":status");
    @JvmField
    @NotNull
    public static final ByteString TARGET_METHOD = ByteString.Companion.encodeUtf8(":method");
    @JvmField
    @NotNull
    public static final ByteString TARGET_PATH = ByteString.Companion.encodeUtf8(":path");
    @JvmField
    @NotNull
    public static final ByteString TARGET_SCHEME = ByteString.Companion.encodeUtf8(":scheme");
    @JvmField
    @NotNull
    public static final ByteString TARGET_AUTHORITY = ByteString.Companion.encodeUtf8(":authority");

    public Header(@NotNull ByteString byteString, @NotNull ByteString byteString2) {
        Intrinsics.checkNotNullParameter(byteString, "name");
        Intrinsics.checkNotNullParameter(byteString2, "value");
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = 32 + this.name.size() + this.value.size();
    }

    public Header(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        this(ByteString.Companion.encodeUtf8(string), ByteString.Companion.encodeUtf8(string2));
    }

    public Header(@NotNull ByteString byteString, @NotNull String string) {
        Intrinsics.checkNotNullParameter(byteString, "name");
        Intrinsics.checkNotNullParameter(string, "value");
        this(byteString, ByteString.Companion.encodeUtf8(string));
    }

    @NotNull
    public String toString() {
        return this.name.utf8() + ": " + this.value.utf8();
    }

    @NotNull
    public final ByteString component1() {
        return this.name;
    }

    @NotNull
    public final ByteString component2() {
        return this.value;
    }

    @NotNull
    public final Header copy(@NotNull ByteString byteString, @NotNull ByteString byteString2) {
        Intrinsics.checkNotNullParameter(byteString, "name");
        Intrinsics.checkNotNullParameter(byteString2, "value");
        return new Header(byteString, byteString2);
    }

    public static /* synthetic */ Header copy$default(Header header, ByteString byteString, ByteString byteString2, int n, Object object) {
        if ((n & 1) != 0) {
            byteString = header.name;
        }
        if ((n & 2) != 0) {
            byteString2 = header.value;
        }
        return header.copy(byteString, byteString2);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n = n * 31 + this.value.hashCode();
        return n;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Header)) {
            return false;
        }
        Header header = (Header)object;
        if (!Intrinsics.areEqual(this.name, header.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, header.value);
    }
}

