/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "call", "Lokhttp3/internal/connection/RealCall;", "getCall", "()Lokhttp3/internal/connection/RealCall;", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "callsPerHost", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host", "", "getHost", "()Ljava/lang/String;", "request", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,551:1\n615#2,4:552\n409#2,9:556\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n*L\n494#1:552,4\n513#1:556,9\n*E\n"})
public final class RealCall$AsyncCall
implements Runnable {
    @NotNull
    private final Callback responseCallback;
    @NotNull
    private volatile AtomicInteger callsPerHost;
    final /* synthetic */ RealCall this$0;

    public RealCall$AsyncCall(@NotNull RealCall realCall, Callback callback) {
        Intrinsics.checkNotNullParameter(callback, "responseCallback");
        this.this$0 = realCall;
        this.responseCallback = callback;
        this.callsPerHost = new AtomicInteger(0);
    }

    @NotNull
    public final AtomicInteger getCallsPerHost() {
        return this.callsPerHost;
    }

    public final void reuseCallsPerHostFrom(@NotNull RealCall$AsyncCall realCall$AsyncCall) {
        Intrinsics.checkNotNullParameter(realCall$AsyncCall, "other");
        this.callsPerHost = realCall$AsyncCall.callsPerHost;
    }

    @NotNull
    public final String getHost() {
        return this.this$0.getOriginalRequest().url().host();
    }

    @NotNull
    public final Request getRequest() {
        return this.this$0.getOriginalRequest();
    }

    @NotNull
    public final RealCall getCall() {
        return this.this$0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeOn(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(executorService, "executorService");
        Dispatcher dispatcher = this.this$0.getClient().dispatcher();
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(dispatcher)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + dispatcher));
        }
        boolean bl2 = false;
        try {
            executorService.execute(this);
            bl2 = true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            try {
                InterruptedIOException interruptedIOException = new InterruptedIOException("executor rejected");
                interruptedIOException.initCause(rejectedExecutionException);
                this.this$0.noMoreExchanges$okhttp(interruptedIOException);
                this.responseCallback.onFailure(this.this$0, interruptedIOException);
            }
            catch (Throwable throwable) {
                this.this$0.getClient().dispatcher().finished$okhttp(this);
                throw throwable;
            }
            this.this$0.getClient().dispatcher().finished$okhttp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = "OkHttp " + this.this$0.redactedUrl$okhttp();
        RealCall realCall = this.this$0;
        boolean bl = false;
        Thread thread2 = Thread.currentThread();
        String string2 = thread2.getName();
        thread2.setName(string);
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            RealCall.access$getTimeout$p(realCall).enter();
            try {
                Response response = realCall.getResponseWithInterceptorChain$okhttp();
                bl3 = true;
                this.responseCallback.onResponse(realCall, response);
            }
            catch (IOException iOException) {
                if (bl3) {
                    Platform.Companion.get().log("Callback failure for " + RealCall.access$toLoggableString(realCall), 4, iOException);
                } else {
                    this.responseCallback.onFailure(realCall, iOException);
                }
            }
            catch (Throwable throwable) {
                realCall.cancel();
                if (!bl3) {
                    IOException iOException = new IOException("canceled due to " + throwable);
                    ExceptionsKt.addSuppressed(iOException, throwable);
                    this.responseCallback.onFailure(realCall, iOException);
                }
                throw throwable;
            }
            finally {
                realCall.getClient().dispatcher().finished$okhttp(this);
            }
        }
        finally {
            thread2.setName(string2);
        }
    }
}

