/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$Adapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
    }

    public boolean excludeField(Field field, boolean bl) {
        return ReflectiveTypeAdapterFactory.excludeField(field, bl, this.excluder);
    }

    static boolean excludeField(Field field, boolean bl, Excluder excluder) {
        return !excluder.excludeClass(field.getType(), bl) && !excluder.excludeField(field, bl);
    }

    private List<String> getFieldNames(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName == null) {
            String string = this.fieldNamingPolicy.translateName(field);
            return Collections.singletonList(string);
        }
        String string = serializedName.value();
        String[] stringArray = serializedName.alternate();
        if (stringArray.length == 0) {
            return Collections.singletonList(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        arrayList.add(string);
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new ReflectiveTypeAdapterFactory$Adapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz));
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson gson, Field field, String string, TypeToken<?> typeToken, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = Primitives.isPrimitive(typeToken.getRawType());
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapter<?> typeAdapter = null;
        if (jsonAdapter != null) {
            typeAdapter = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter);
        }
        boolean bl5 = bl3 = typeAdapter != null;
        if (typeAdapter == null) {
            typeAdapter = gson.getAdapter(typeToken);
        }
        TypeAdapter<?> typeAdapter2 = typeAdapter;
        return new ReflectiveTypeAdapterFactory$1(this, string, bl, bl2, field, bl3, typeAdapter2, gson, typeToken, bl4);
    }

    private Map<String, ReflectiveTypeAdapterFactory$BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.getType();
        while (clazz != Object.class) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (!bl && !bl2) continue;
                ReflectionHelper.makeAccessible(field);
                Type type2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField = null;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string = list.get(i);
                    if (i != 0) {
                        bl = false;
                    }
                    ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField2 = this.createBoundField(gson, field, string, TypeToken.get(type2), bl, bl2);
                    ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField3 = linkedHashMap.put(string, reflectiveTypeAdapterFactory$BoundField2);
                    if (reflectiveTypeAdapterFactory$BoundField != null) continue;
                    reflectiveTypeAdapterFactory$BoundField = reflectiveTypeAdapterFactory$BoundField3;
                }
                if (reflectiveTypeAdapterFactory$BoundField == null) continue;
                throw new IllegalArgumentException(type + " declares multiple JSON fields named " + reflectiveTypeAdapterFactory$BoundField.name);
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }
}

